package ga.clustering;

import ga.core.algorithm.util.RandomSingleton;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

import org.apache.commons.math.stat.clustering.Cluster;
import org.apache.commons.math.stat.clustering.Clusterable;
import org.apache.commons.math.stat.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math.util.FastMath;

public class TestKMeansPlusPlus {
  public static void main(final String[] args) {
    final Random rnd = RandomSingleton.getRandom();
    final KMeansPlusPlusClusterer<TestObject> clusterer = new KMeansPlusPlusClusterer<TestKMeansPlusPlus.TestObject>(
        rnd);

    final List<TestObject> points = new ArrayList<TestObject>();
    for (int i = 0; i < 10; i++) {
      points.add(new TestObject(rnd.nextInt(4), rnd.nextInt(4)));
    }

    final List<Cluster<TestObject>> list = clusterer.cluster(points, 4, 100);

    for (final Cluster<TestObject> c : list) {
      System.err.println("Center " + c.getCenter());
      System.err.println(c.getPoints());

      double dist = 0d;

      if (c.getPoints().size() > 1) {

        for (int i = 0; i < c.getPoints().size() - 1; i++) {
          for (int j = i + 1; j < c.getPoints().size(); j++) {
            dist += c.getPoints().get(i).distanceFrom(c.getPoints().get(j));
          }
        }

        dist /= c.getPoints().size() * (c.getPoints().size() - 1);
      }

      System.err.println("Distance: " + dist);
    }
  }

  private static class TestObject implements Clusterable<TestObject> {
    private final double x, y;

    public TestObject(final double x, final double y) {
      this.x = x;
      this.y = y;
    }

    @Override
    public double distanceFrom(final TestObject p) {
      return FastMath.sqrt(FastMath.pow(x - p.x, 2f)
          + FastMath.pow(y - p.y, 2f));
    }

    @Override
    public TestObject centroidOf(final Collection<TestObject> p) {
      double xT = 0d;
      double yT = 0d;
      for (final TestObject o : p) {
        xT += o.x;
        yT += o.y;
      }

      return new TestObject(xT / p.size(), yT / p.size());
    }

    @Override
    public String toString() {
      return "(" + (float) x + " ," + (float) y + ")";
    }
  }
}
